/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.runners;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.io.MozFileWriter;
import org.mozilla.translator.io.MozIo;
import org.mozilla.translator.kernel.Log;

public class WritePackageRunner
extends Thread {
    private MozInstall install;
    private String fileName;
    private String localeName;
    private String author;
    private String display;
    private String preview;

    public WritePackageRunner(MozInstall i, String fn, String ln, String a, String d, String p) {
        this.install = i;
        this.fileName = fn;
        this.localeName = ln;
        this.author = a;
        this.display = d;
        this.preview = p;
    }

    public void run() {
        int filesDone = 0;
        MainWindow vindue = MainWindow.getDefaultInstance();
        File baseDir = new File(this.fileName);
        this.makeDir(baseDir);
        File tempDir = new File(baseDir, "locale");
        this.makeDir(tempDir);
        tempDir = new File(tempDir, this.localeName);
        this.makeDir(tempDir);
        Iterator componentIterator = this.install.getChildIterator();
        while (componentIterator.hasNext()) {
            MozComponent currentComponent = (MozComponent)componentIterator.next();
            File componentDir = new File(baseDir, currentComponent.getName());
            this.makeDir(componentDir);
            Iterator subcomponentIterator = currentComponent.getChildIterator();
            while (subcomponentIterator.hasNext()) {
                File subcomponentDir;
                MozComponent currentSubComponent = (MozComponent)subcomponentIterator.next();
                File localeDir = componentDir;
                this.makeDir(localeDir);
                if (currentSubComponent.getName().equals("MT_default")) {
                    subcomponentDir = localeDir;
                } else {
                    subcomponentDir = new File(localeDir, currentSubComponent.getName());
                    this.makeDir(subcomponentDir);
                }
                Iterator fileIterator = currentSubComponent.getChildIterator();
                while (fileIterator.hasNext()) {
                    MozFile currentFile = (MozFile)fileIterator.next();
                    vindue.setStatus(String.valueOf(String.valueOf(new StringBuffer("Files done: ").append(filesDone).append(", currently writing: ").append(currentFile))));
                    this.writeFile(subcomponentDir, currentFile);
                    ++filesDone;
                }
            }
        }
        vindue.setStatus("Writing manifest file");
        this.writeManifest(baseDir);
        vindue.setStatus("Ready");
    }

    private void makeDir(File fil) {
        if (!fil.exists()) {
            fil.mkdir();
        }
    }

    private void writeFile(File dir, MozFile fil) {
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(dir))).append(File.separator).append(fil))));
            MozFileWriter writer = MozIo.getFileWriter(fil, fos);
            if (writer != null) {
                writer.writeFile(this.localeName);
            }
        }
        catch (Exception e) {
            Log.write("Exception : ".concat(String.valueOf(String.valueOf(e))));
        }
    }

    private void writeManifest(File dir) {
        try {
            File fil = new File(dir, "manifest.rdf");
            FileWriter fw = new FileWriter(fil);
            PrintWriter pw = new PrintWriter(fw);
            pw.println("<?xml version=\"1.0\"?>");
            pw.println("<RDF:RDF xmlns:RDF=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
            pw.println("         xmlns:chrome=\"http://www.mozilla.org/rdf/chrome#\">");
            pw.println();
            pw.println("  <RDF:Seq about=\"urn:mozilla:locale:root\">");
            pw.println(String.valueOf(String.valueOf(new StringBuffer("    <RDF:li resource=\"urn:mozilla:locale:").append(this.localeName).append("\"/>"))));
            pw.println("  </RDF:Seq>");
            pw.println();
            pw.println(String.valueOf(String.valueOf(new StringBuffer("  <RDF:Description about=\"urn:mozilla:locale:").append(this.localeName).append("\""))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("       chrome:displayName=\"").append(this.display).append("\""))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("       chrome:author=\"").append(this.author).append("\""))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("       chrome:name=\"").append(this.localeName).append("\""))));
            pw.println(String.valueOf(String.valueOf(new StringBuffer("       chrome:previewURL=\"").append(this.preview).append("\">"))));
            pw.println();
            pw.println("    <chrome:packages>");
            pw.println(String.valueOf(String.valueOf(new StringBuffer("      <RDF:Seq about=\"urn:mozilla:locale:").append(this.localeName).append(":packages\">"))));
            Iterator componentIterator = this.install.getChildIterator();
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                pw.println(String.valueOf(String.valueOf(new StringBuffer("        <RDF:li resource=\"urn:mozilla:locale:").append(this.localeName).append(":").append(currentComponent.getName()).append("\"/>"))));
            }
            pw.println("      </RDF:Seq>");
            pw.println("    </chrome:packages>");
            pw.println("  </RDF:Description>");
            pw.println("</RDF:RDF>");
            pw.close();
        }
        catch (Exception e) {
            Log.write("Error writing manifest file");
        }
    }
}

