/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.datamodel.Translation;
import org.mozilla.translator.io.MozFileReader;

public class PropertiesReader
extends MozFileReader {
    public PropertiesReader(MozFile f, InputStream i) {
        super(f, i);
    }

    public void readFile(String localeName, List changeList) throws IOException {
        Properties prop = new Properties();
        prop.load(this.is);
        this.is.close();
        Enumeration<?> enumeration = prop.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String text = prop.getProperty(key);
            Phrase currentPhrase = (Phrase)this.fil.getChildByName(key);
            if (localeName.equalsIgnoreCase("en-us")) {
                if (currentPhrase == null) {
                    currentPhrase = new Phrase(key, this.fil, text, "", false);
                    this.fil.addChild(currentPhrase);
                    changeList.add(currentPhrase);
                } else if (!currentPhrase.getText().equals(text)) {
                    currentPhrase.setText(text);
                    changeList.add(currentPhrase);
                }
                currentPhrase.setMarked(true);
                continue;
            }
            if (currentPhrase == null) continue;
            Translation currentTranslation = (Translation)currentPhrase.getChildByName(localeName);
            if (currentTranslation == null) {
                currentTranslation = new Translation(localeName, currentPhrase, text);
                currentPhrase.addChild(currentTranslation);
                continue;
            }
            currentTranslation.setText(text);
        }
    }
}

