/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.mozilla.translator.datamodel.Glossary;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.datamodel.Translation;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.io.MozInstallAccess;
import org.mozilla.translator.kernel.Log;
import org.mozilla.translator.kernel.Settings;

public class GlossaryAccess
implements MozInstallAccess {
    public void load() {
        MainWindow vindue = MainWindow.getDefaultInstance();
        try {
            vindue.setStatus("Loading file");
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(Settings.getString("System.Glossaryfile", "glossary.zip"));
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            prop.load(zis);
            zis.closeEntry();
            zis.close();
            int installMax = Integer.parseInt(prop.getProperty("install.count"));
            for (int installCount = 0; installCount < installMax; ++installCount) {
                String statusPrefix = String.valueOf(String.valueOf(new StringBuffer("Parsing install ").append(installCount + 1).append(" of ").append(installMax).append(" : ")));
                String installPrefix = String.valueOf(String.valueOf(new StringBuffer("").append(installCount).append(".")));
                String name = prop.getProperty(String.valueOf(String.valueOf(installPrefix)).concat("name"), "");
                String path = prop.getProperty(String.valueOf(String.valueOf(installPrefix)).concat("path"), "");
                int componentMax = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(installPrefix)).concat("count"), "0"));
                MozInstall currentInstall = new MozInstall(name, path);
                Glossary.getDefaultInstance().addChild(currentInstall);
                for (int componentCount = 0; componentCount < componentMax; ++componentCount) {
                    String componentPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(installPrefix))).append(componentCount).append(".")));
                    name = prop.getProperty(String.valueOf(String.valueOf(componentPrefix)).concat("name"), "");
                    String statusText = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(statusPrefix))).append("Component ").append(componentCount + 1).append(" of ").append(componentMax).append(" ( ").append(name).append(")")));
                    vindue.setStatus(statusText);
                    int subcomponentMax = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(componentPrefix)).concat("count"), "0"));
                    MozComponent currentComponent = new MozComponent(name, currentInstall);
                    currentInstall.addChild(currentComponent);
                    for (int subcomponentCount = 0; subcomponentCount < subcomponentMax; ++subcomponentCount) {
                        String subcomponentPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(componentPrefix))).append(subcomponentCount).append(".")));
                        name = prop.getProperty(String.valueOf(String.valueOf(subcomponentPrefix)).concat("name"), "");
                        int fileMax = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(subcomponentPrefix)).concat("count"), "0"));
                        MozComponent currentSubcomponent = new MozComponent(name, currentComponent);
                        currentComponent.addChild(currentSubcomponent);
                        for (int fileCount = 0; fileCount < fileMax; ++fileCount) {
                            String filePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(subcomponentPrefix))).append(fileCount).append(".")));
                            name = prop.getProperty(String.valueOf(String.valueOf(filePrefix)).concat("name"), "");
                            int phraseMax = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(filePrefix)).concat("count"), "0"));
                            MozFile currentFile = new MozFile(name, currentSubcomponent);
                            currentSubcomponent.addChild(currentFile);
                            for (int phraseCount = 0; phraseCount < phraseMax; ++phraseCount) {
                                Phrase labelPhrase;
                                String phrasePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(filePrefix))).append(phraseCount).append(".")));
                                String key = prop.getProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("key"), "");
                                String note = prop.getProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("note"), "");
                                String text = prop.getProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("text"), "");
                                boolean keep = Boolean.valueOf(prop.getProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("keep")));
                                int translationMax = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("count"), ""));
                                Phrase currentPhrase = new Phrase(key, currentFile, text, note, keep);
                                currentPhrase.setAccessConnection(null);
                                currentPhrase.setCommandConnection(null);
                                currentFile.addChild(currentPhrase);
                                if (key.endsWith(".label")) {
                                    Phrase accessPhrase = (Phrase)currentFile.getChildByName(String.valueOf(String.valueOf(key.substring(0, key.length() - 6))).concat(".accesskey"), false);
                                    Phrase commandPhrase = (Phrase)currentFile.getChildByName(String.valueOf(String.valueOf(key.substring(0, key.length() - 6))).concat(".commandkey"), false);
                                    currentPhrase.setAccessConnection(accessPhrase);
                                    currentPhrase.setCommandConnection(commandPhrase);
                                }
                                if (key.endsWith(".accesskey") && (labelPhrase = (Phrase)currentFile.getChildByName(String.valueOf(String.valueOf(key.substring(0, key.length() - 10))).concat(".label"), false)) != null) {
                                    labelPhrase.setAccessConnection(currentPhrase);
                                }
                                if (key.endsWith(".commandkey") && (labelPhrase = (Phrase)currentFile.getChildByName(String.valueOf(String.valueOf(key.substring(0, key.length() - 11))).concat(".label"), false)) != null) {
                                    labelPhrase.setCommandConnection(currentPhrase);
                                }
                                for (int translationCount = 0; translationCount < translationMax; ++translationCount) {
                                    String translationPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(phrasePrefix))).append(translationCount).append(".")));
                                    name = prop.getProperty(String.valueOf(String.valueOf(translationPrefix)).concat("name"), "");
                                    String comment = prop.getProperty(String.valueOf(String.valueOf(translationPrefix)).concat("comment"), "");
                                    text = prop.getProperty(String.valueOf(String.valueOf(translationPrefix)).concat("text"), "");
                                    int status = Integer.parseInt(prop.getProperty(String.valueOf(String.valueOf(translationPrefix)).concat("status"), "0"));
                                    Translation currentTranslation = new Translation(name, currentPhrase, text, status, comment);
                                    currentPhrase.addChild(currentTranslation);
                                }
                            }
                        }
                    }
                }
            }
            MainWindow.getDefaultInstance().setStatus("Ready");
        }
        catch (Exception e) {
            Log.write("Exception : ".concat(String.valueOf(String.valueOf(e))));
            Log.write("Error loading the glossary file");
        }
    }

    public void save() {
        MainWindow vindue = MainWindow.getDefaultInstance();
        Properties prop = new Properties();
        int installCount = 0;
        Iterator installIterator = Glossary.getDefaultInstance().getChildIterator();
        while (installIterator.hasNext()) {
            String installPrefix = String.valueOf(String.valueOf(new StringBuffer("").append(installCount).append(".")));
            MozInstall currentInstall = (MozInstall)installIterator.next();
            prop.setProperty(String.valueOf(String.valueOf(installPrefix)).concat("name"), currentInstall.getName());
            prop.setProperty(String.valueOf(String.valueOf(installPrefix)).concat("path"), currentInstall.getPath());
            Iterator componentIterator = currentInstall.getChildIterator();
            int componentCount = 0;
            String statusPrefix = String.valueOf(String.valueOf(new StringBuffer("Parsing install ").append(installCount + 1).append(" : ")));
            while (componentIterator.hasNext()) {
                String componentPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(installPrefix))).append(componentCount).append(".")));
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                String statusText = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(statusPrefix))).append("Component ").append(componentCount + 1).append(" ( ").append(currentComponent.getName()).append(")")));
                vindue.setStatus(statusText);
                prop.setProperty(String.valueOf(String.valueOf(componentPrefix)).concat("name"), currentComponent.getName());
                Iterator subcomponentIterator = currentComponent.getChildIterator();
                int subcomponentCount = 0;
                while (subcomponentIterator.hasNext()) {
                    String subcomponentPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(componentPrefix))).append(subcomponentCount).append(".")));
                    MozComponent currentSubcomponent = (MozComponent)subcomponentIterator.next();
                    prop.setProperty(String.valueOf(String.valueOf(subcomponentPrefix)).concat("name"), currentSubcomponent.getName());
                    Iterator fileIterator = currentSubcomponent.getChildIterator();
                    int fileCount = 0;
                    while (fileIterator.hasNext()) {
                        String filePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(subcomponentPrefix))).append(fileCount).append(".")));
                        MozFile currentFile = (MozFile)fileIterator.next();
                        prop.setProperty(String.valueOf(String.valueOf(filePrefix)).concat("name"), currentFile.getName());
                        Iterator phraseIterator = currentFile.getChildIterator();
                        int phraseCount = 0;
                        while (phraseIterator.hasNext()) {
                            String phrasePrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(filePrefix))).append(phraseCount).append(".")));
                            Phrase currentPhrase = (Phrase)phraseIterator.next();
                            prop.setProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("key"), currentPhrase.getName());
                            prop.setProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("note"), currentPhrase.getNote());
                            prop.setProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("text"), currentPhrase.getText());
                            prop.setProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("keep"), "".concat(String.valueOf(String.valueOf(currentPhrase.getKeepOriginal()))));
                            Iterator translationIterator = currentPhrase.getChildIterator();
                            int translationCount = 0;
                            while (translationIterator.hasNext()) {
                                String translationPrefix = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(phrasePrefix))).append(translationCount).append(".")));
                                Translation currentTranslation = (Translation)translationIterator.next();
                                prop.setProperty(String.valueOf(String.valueOf(translationPrefix)).concat("name"), currentTranslation.getName());
                                if (!currentTranslation.getComment().equals("")) {
                                    prop.setProperty(String.valueOf(String.valueOf(translationPrefix)).concat("comment"), currentTranslation.getComment());
                                }
                                prop.setProperty(String.valueOf(String.valueOf(translationPrefix)).concat("text"), currentTranslation.getText());
                                if (currentTranslation.getStatus() != 0) {
                                    prop.setProperty(String.valueOf(String.valueOf(translationPrefix)).concat("status"), "".concat(String.valueOf(String.valueOf(currentTranslation.getStatus()))));
                                }
                                ++translationCount;
                            }
                            prop.setProperty(String.valueOf(String.valueOf(phrasePrefix)).concat("count"), "".concat(String.valueOf(String.valueOf(translationCount))));
                            ++phraseCount;
                        }
                        prop.setProperty(String.valueOf(String.valueOf(filePrefix)).concat("count"), "".concat(String.valueOf(String.valueOf(phraseCount))));
                        ++fileCount;
                    }
                    prop.setProperty(String.valueOf(String.valueOf(subcomponentPrefix)).concat("count"), "".concat(String.valueOf(String.valueOf(fileCount))));
                    ++subcomponentCount;
                }
                prop.setProperty(String.valueOf(String.valueOf(componentPrefix)).concat("count"), "".concat(String.valueOf(String.valueOf(subcomponentCount))));
                ++componentCount;
            }
            prop.setProperty(String.valueOf(String.valueOf(installPrefix)).concat("count"), "".concat(String.valueOf(String.valueOf(componentCount))));
            ++installCount;
        }
        prop.setProperty("install.count", "".concat(String.valueOf(String.valueOf(installCount))));
        try {
            vindue.setStatus("Saving file");
            FileOutputStream fos = new FileOutputStream(Settings.getString("System.Glossaryfile", "glossary.zip"));
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry ze = new ZipEntry("glossary.txt");
            zos.putNextEntry(ze);
            prop.store(zos, "Translated with MozillaTranslator ".concat(String.valueOf(String.valueOf(Settings.getString("System.Version", "(unknown version)")))));
            zos.closeEntry();
            zos.close();
        }
        catch (Exception e) {
            Log.write("error writing glossary file");
        }
        vindue.setStatus("Ready");
    }
}

