/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.mozilla.translator.datamodel.Glossary;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.gui.dialog.EditInstallDialog;
import org.mozilla.translator.kernel.Utils;

public class InstallAdminDialog
extends JDialog {
    private JButton exitButton;
    private JPanel listPanel;
    private JScrollPane listScroll;
    private JList installList;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;

    public InstallAdminDialog(Frame parent) {
        super(parent, "Install configuration", true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.exitButton);
        this.pack();
        Utils.placeFrameAtCenter(this);
    }

    private void initComponents() {
        this.exitButton = new JButton();
        this.listPanel = new JPanel();
        this.listScroll = new JScrollPane();
        this.installList = new JList();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                InstallAdminDialog.this.closeWindow(evt);
            }
        });
        this.exitButton.setToolTipText("Leave the dialogbox");
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InstallAdminDialog.this.exitButtonPressed(evt);
            }
        });
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(0, 3, 3, 3);
        this.getContentPane().add((Component)this.exitButton, gridBagConstraints1);
        this.listPanel.setLayout(new GridBagLayout());
        this.listPanel.setBorder(new TitledBorder(new EtchedBorder(), "Known installations", 4, 2, new Font("Dialog", 0, 10)));
        this.installList.setModel(Glossary.getDefaultInstance());
        this.installList.setPrototypeCellValue("netscape 60 Preview Release 10 ");
        this.listScroll.setViewportView(this.installList);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridheight = 3;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints2.anchor = 18;
        this.listPanel.add((Component)this.listScroll, gridBagConstraints2);
        this.addButton.setToolTipText("Add a new Mozilla installation");
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InstallAdminDialog.this.addButtonPressed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints2.anchor = 18;
        this.listPanel.add((Component)this.addButton, gridBagConstraints2);
        this.editButton.setToolTipText("Edit the selected Mozilla installation");
        this.editButton.setText("Edit");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InstallAdminDialog.this.editButtonPressed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 3, 3);
        gridBagConstraints2.anchor = 18;
        this.listPanel.add((Component)this.editButton, gridBagConstraints2);
        this.removeButton.setToolTipText("Remove the selected Mozilla installation");
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InstallAdminDialog.this.removeButtonPressed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 3, 3);
        gridBagConstraints2.anchor = 18;
        this.listPanel.add((Component)this.removeButton, gridBagConstraints2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.listPanel, gridBagConstraints1);
    }

    private void closeWindow(WindowEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void exitButtonPressed(ActionEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void removeButtonPressed(ActionEvent evt) {
        MozInstall install = (MozInstall)this.installList.getSelectedValue();
        int result = JOptionPane.showConfirmDialog(this.removeButton, "Really remove: ".concat(String.valueOf(String.valueOf(install))), "Remove Installation", 2, 2);
        if (result == 0) {
            Glossary.getDefaultInstance().removeChild(install);
            Glossary.getDefaultInstance().fireContentsChanged();
        }
    }

    private void editButtonPressed(ActionEvent evt) {
        block0: {
            MozInstall install = (MozInstall)this.installList.getSelectedValue();
            EditInstallDialog eid = new EditInstallDialog((Frame)MainWindow.getDefaultInstance(), install);
            if (!eid.visDialog()) break block0;
            Glossary.getDefaultInstance().fireContentsChanged();
        }
    }

    private void addButtonPressed(ActionEvent evt) {
        MozInstall install = new MozInstall("", "");
        EditInstallDialog eid = new EditInstallDialog((Frame)MainWindow.getDefaultInstance(), install);
        if (eid.visDialog()) {
            Glossary.getDefaultInstance().addChild(install);
            Glossary.getDefaultInstance().fireContentsChanged();
        }
    }
}

