/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.gui;

import java.awt.Component;
import javax.swing.Action;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.mozilla.translator.actions.AboutAction;
import org.mozilla.translator.actions.AdvancedSearchAction;
import org.mozilla.translator.actions.ChromeViewAction;
import org.mozilla.translator.actions.EditPhraseAction;
import org.mozilla.translator.actions.ExportPartialGlossaryAction;
import org.mozilla.translator.actions.ExportTextAction;
import org.mozilla.translator.actions.ImportLocaleAction;
import org.mozilla.translator.actions.ImportOldGlossaryAction;
import org.mozilla.translator.actions.ImportPartialGlossaryAction;
import org.mozilla.translator.actions.IndenticalStringAction;
import org.mozilla.translator.actions.InstallManagerAction;
import org.mozilla.translator.actions.KeepViewAction;
import org.mozilla.translator.actions.KeybindingCheckerAction;
import org.mozilla.translator.actions.QuitAction;
import org.mozilla.translator.actions.RedundantViewAction;
import org.mozilla.translator.actions.SaveGlossaryAction;
import org.mozilla.translator.actions.SearchViewAction;
import org.mozilla.translator.actions.SetupAction;
import org.mozilla.translator.actions.UntranslatedViewAction;
import org.mozilla.translator.actions.UpdateInstallAction;
import org.mozilla.translator.actions.WriteJarAction;
import org.mozilla.translator.actions.WritePackageAction;
import org.mozilla.translator.actions.WriteXpiAction;
import org.mozilla.translator.gui.MozFrame;
import org.mozilla.translator.kernel.Settings;
import org.mozilla.translator.kernel.Utils;

public class MainWindow
extends JFrame {
    private static MainWindow instance;
    private JLabel statusLine;
    private JDesktopPane desktop;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenu importMenu;
    private JMenu exportMenu;
    private JMenu editMenu;

    public static void init() {
        instance = new MainWindow();
    }

    public static MainWindow getDefaultInstance() {
        return instance;
    }

    private MainWindow() {
        super("MozillaTranslator, Version ".concat(String.valueOf(String.valueOf(Settings.getString("System.Version", "X.xx")))));
        this.setDefaultCloseOperation(0);
        this.desktop = new JDesktopPane();
        this.statusLine = new JLabel("Status: Loading...");
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.importMenu = new JMenu("Import");
        this.exportMenu = new JMenu("Export");
        this.editMenu = new JMenu("Edit");
        this.helpMenu = new JMenu("Help");
        this.addMenuItem(this.fileMenu, new InstallManagerAction());
        this.addMenuItem(this.fileMenu, new UpdateInstallAction());
        this.addMenuItem(this.fileMenu, new SaveGlossaryAction());
        this.fileMenu.addSeparator();
        this.addMenuItem(this.fileMenu, new SetupAction());
        this.fileMenu.addSeparator();
        QuitAction qaction = new QuitAction();
        this.addMenuItem(this.fileMenu, qaction);
        this.addWindowListener(qaction);
        this.addMenuItem(this.importMenu, new ImportPartialGlossaryAction());
        this.importMenu.addSeparator();
        this.addMenuItem(this.importMenu, new ImportLocaleAction());
        this.importMenu.addSeparator();
        this.addMenuItem(this.importMenu, new ImportOldGlossaryAction());
        this.addMenuItem(this.exportMenu, new ExportPartialGlossaryAction());
        this.exportMenu.addSeparator();
        this.addMenuItem(this.exportMenu, new WritePackageAction());
        this.addMenuItem(this.exportMenu, new WriteJarAction());
        this.addMenuItem(this.exportMenu, new WriteXpiAction());
        this.exportMenu.addSeparator();
        this.addMenuItem(this.exportMenu, new ExportTextAction());
        this.addMenuItem(this.editMenu, new ChromeViewAction(), "alt C");
        this.editMenu.addSeparator();
        this.addMenuItem(this.editMenu, new UntranslatedViewAction(), "alt U");
        this.addMenuItem(this.editMenu, new RedundantViewAction(), "alt R");
        this.addMenuItem(this.editMenu, new KeepViewAction(), "alt K");
        this.addMenuItem(this.editMenu, new IndenticalStringAction());
        this.editMenu.addSeparator();
        this.addMenuItem(this.editMenu, new EditPhraseAction(), "alt E");
        this.editMenu.addSeparator();
        this.addMenuItem(this.editMenu, new SearchViewAction(), "alt S");
        this.addMenuItem(this.editMenu, new AdvancedSearchAction());
        this.addMenuItem(this.editMenu, new KeybindingCheckerAction());
        this.addMenuItem(this.helpMenu, new AboutAction());
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.importMenu);
        this.menuBar.add(this.exportMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().add((Component)this.desktop, "Center");
        this.getContentPane().add((Component)this.statusLine, "South");
        ((Component)this).setSize(800, 600);
        Utils.placeFrameAtCenter(this);
    }

    public void setStatus(String text) {
        this.statusLine.setText(text);
    }

    public void addWindow(JInternalFrame win) {
        this.desktop.add(win);
    }

    private void addMenuItem(JMenu adMenu, Action action) {
        this.addMenuItem(adMenu, action, null);
    }

    private void addMenuItem(JMenu adMenu, Action action, String key) {
        JMenuItem item = adMenu.add(action);
        if (key != null) {
            item.setAccelerator(KeyStroke.getKeyStroke(key));
        }
    }

    public MozFrame getInnerFrame() {
        return (MozFrame)((Object)this.desktop.getSelectedFrame());
    }
}

