/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import java.io.File;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import org.mozilla.translator.datamodel.MozComponent;
import org.mozilla.translator.datamodel.MozFile;
import org.mozilla.translator.datamodel.MozInstall;
import org.mozilla.translator.datamodel.MozTreeNode;
import org.mozilla.translator.gui.MainWindow;
import org.mozilla.translator.kernel.Settings;
import org.mozilla.translator.runners.LoadGlossaryRunner;

public class Glossary
extends MozTreeNode {
    private static Glossary instance;

    public static void init() {
        instance = new Glossary();
    }

    public static Glossary getDefaultInstance() {
        return instance;
    }

    private Glossary() {
        super("MozillaTranslator Glossary", null);
        File glosFile = new File(Settings.getString("System.Glossaryfile", "glossary.zip"));
        if (glosFile.exists()) {
            LoadGlossaryRunner lgr = new LoadGlossaryRunner();
            lgr.start();
        } else {
            MainWindow.getDefaultInstance().setStatus("Ready");
            String defpath = "c:/mozilla/bin/chrome/";
            MozInstall install = new MozInstall("Mozilla Natual (en-US.jar)", String.valueOf(String.valueOf(defpath)).concat("en-US.jar"));
            this.addChild(install);
            this.fireContentsChanged();
            install = new MozInstall("Platform: Windows (en-win.jar)", String.valueOf(String.valueOf(defpath)).concat("en-win.jar"));
            this.addChild(install);
            this.fireContentsChanged();
            install = new MozInstall("Platform: UNIX (en-unix.jar)", String.valueOf(String.valueOf(defpath)).concat("en-unix.jar"));
            this.addChild(install);
            this.fireContentsChanged();
            install = new MozInstall("Platform: Macintoch (en-mac.jar)", String.valueOf(String.valueOf(defpath)).concat("en-mac.jar"));
            this.addChild(install);
            this.fireContentsChanged();
            install = new MozInstall("Region Data (US.jar)", String.valueOf(String.valueOf(defpath)).concat("US.jar"));
            this.addChild(install);
            this.fireContentsChanged();
            install = new MozInstall("Chatzilla (chatzilla.jar)", String.valueOf(String.valueOf(defpath)).concat("chatzilla.jar"));
            this.addChild(install);
            this.fireContentsChanged();
            install = new MozInstall("Venkman (venkman.jar)", String.valueOf(String.valueOf(defpath)).concat("venkman.jar"));
            this.addChild(install);
            this.fireContentsChanged();
            install = new MozInstall("DOM Inspctr (inspector.jar)", String.valueOf(String.valueOf(defpath)).concat("inspector.jar"));
            this.addChild(install);
            this.fireContentsChanged();
        }
    }

    public DefaultMutableTreeNode getTreeRoot() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        Iterator installIterator = this.children.iterator();
        while (installIterator.hasNext()) {
            MozInstall currentInstall = (MozInstall)installIterator.next();
            DefaultMutableTreeNode installNode = new DefaultMutableTreeNode(currentInstall);
            root.add(installNode);
            Iterator componentIterator = currentInstall.getChildIterator();
            while (componentIterator.hasNext()) {
                MozComponent currentComponent = (MozComponent)componentIterator.next();
                DefaultMutableTreeNode componentNode = new DefaultMutableTreeNode(currentComponent);
                installNode.add(componentNode);
                Iterator subcomponentIterator = currentComponent.getChildIterator();
                while (subcomponentIterator.hasNext()) {
                    MozComponent currentSubcomponent = (MozComponent)subcomponentIterator.next();
                    DefaultMutableTreeNode subcomponentNode = new DefaultMutableTreeNode(currentSubcomponent);
                    componentNode.add(subcomponentNode);
                    Iterator fileIterator = currentSubcomponent.getChildIterator();
                    while (fileIterator.hasNext()) {
                        MozFile currentFile = (MozFile)fileIterator.next();
                        DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(currentFile);
                        subcomponentNode.add(fileNode);
                    }
                }
            }
        }
        return root;
    }
}

