/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.translator.datamodel;

import org.mozilla.translator.datamodel.Phrase;
import org.mozilla.translator.datamodel.Translation;

public class Filter {
    public static final int FIELD_KEY = 1;
    public static final int FIELD_ORG_TEXT = 2;
    public static final int FIELD_NOTE = 3;
    public static final int FIELD_COMMENT = 4;
    public static final int FIELD_TRANS_TEXT = 5;
    public static final int RULE_IS = 1;
    public static final int RULE_IS_NOT = 2;
    public static final int RULE_CONTAINS = 3;
    public static final int RULE_CONTAINS_NOT = 4;
    public static final int RULE_STARTS_WITH = 5;
    public static final int RULE_ENDS_WITH = 6;
    private int rule;
    private int field;
    private boolean caseCheck;
    private String value;
    private String localeName;

    public Filter(int r, int f, String v, boolean cc, String ln) {
        this.rule = r;
        this.field = f;
        this.value = v;
        this.caseCheck = cc;
        this.localeName = ln;
    }

    public int getRule() {
        return this.rule;
    }

    public int getField() {
        return this.field;
    }

    public String getValue() {
        return this.value;
    }

    public void setRule(int r) {
        this.rule = r;
    }

    public void setField(int f) {
        this.field = f;
    }

    public void setValue(String v) {
        this.value = v;
    }

    public String toString() {
        String result = String.valueOf(String.valueOf(new StringBuffer("Rule : ").append(this.rule).append("\n")));
        result = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(result))).append("Field  : ").append(this.field).append("\n")));
        result = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(result))).append("value  : ").append(this.value).append("\n")));
        result = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(result))).append("case   : ").append(this.caseCheck).append("\n")));
        result = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(result))).append("locale : ").append(this.localeName).append("\n")));
        return result;
    }

    public boolean check(Phrase phrase) {
        boolean result;
        block25: {
            block24: {
                Translation translation = (Translation)phrase.getChildByName(this.localeName);
                String compareText = null;
                result = false;
                switch (this.field) {
                    case 1: {
                        compareText = phrase.getName();
                        break;
                    }
                    case 2: {
                        compareText = phrase.getText();
                        break;
                    }
                    case 3: {
                        compareText = phrase.getNote();
                        break;
                    }
                    case 5: {
                        if (translation == null) break;
                        compareText = translation.getText();
                        break;
                    }
                    case 4: {
                        if (translation == null) break;
                        compareText = translation.getComment();
                    }
                }
                if (compareText == null) break block24;
                if (!this.caseCheck) {
                    compareText = compareText.toLowerCase();
                    this.value = this.value.toLowerCase();
                }
                switch (this.rule) {
                    case 1: {
                        if (compareText.equals(this.value)) {
                            result = true;
                            break;
                        }
                        break block25;
                    }
                    case 2: {
                        if (!compareText.equals(this.value)) {
                            result = true;
                            break;
                        }
                        break block25;
                    }
                    case 3: {
                        if (compareText.indexOf(this.value) != -1) {
                            result = true;
                            break;
                        }
                        break block25;
                    }
                    case 4: {
                        if (compareText.indexOf(this.value) == -1) {
                            result = true;
                            break;
                        }
                        break block25;
                    }
                    case 5: {
                        if (compareText.startsWith(this.value)) {
                            result = true;
                            break;
                        }
                        break block25;
                    }
                    case 6: {
                        if (!compareText.endsWith(this.value)) break block25;
                        result = true;
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block25;
            }
            result = false;
        }
        return result;
    }

    static {
        FIELD_KEY = 1;
        FIELD_ORG_TEXT = 2;
        FIELD_NOTE = 3;
        FIELD_COMMENT = 4;
        FIELD_TRANS_TEXT = 5;
        RULE_IS = 1;
        RULE_IS_NOT = 2;
        RULE_CONTAINS = 3;
        RULE_CONTAINS_NOT = 4;
        RULE_STARTS_WITH = 5;
        RULE_ENDS_WITH = 6;
    }
}

