/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 *  except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/

 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is MozillaTranslator (Mozilla Localization Tool)
 *
 * The Initial Developer of the Original Code is Henrik Lynggaard Hansen
 *
 * Portions created by Henrik Lynggard Hansen are
 * Copyright (C) Henrik Lynggaard Hansen.
 * All Rights Reserved.
 *
 * Contributor(s):
 * Henrik Lynggaard Hansen (Initial Code)
 *
 */
package org.mozilla.translator.runners;

import java.util.*;
import java.util.zip.*;
import java.io.*;

import org.mozilla.translator.datamodel.*;
import org.mozilla.translator.io.*;
import org.mozilla.translator.kernel.*;
import org.mozilla.translator.gui.*;
/**
 *
 * @author  Henrik
 * @version 4.1
 */
public class WriteXpiRunner extends Thread {

    private MozInstall install;
    private String fileName;
    private String localeName, langcode, regioncode;
    private String author,display,preview;
    private String version;

    private File zipFile;
    private FileOutputStream fos;
    private ZipOutputStream zos;
    private BufferedOutputStream bos;


    private String entryName;

    /** Creates new WritePackageRunner */
    public WriteXpiRunner(MozInstall i,String fn,String ln,String a,String d,String p,String v)
    {
        fileName=fn;
        localeName=ln;
	    // piaip: Thu Sep 27 12:24:20 CST 2001
	    // we need lang code/region code here
	    int dashindex = localeName.indexOf('-');
	    langcode = localeName.substring(0, dashindex);
	    regioncode = localeName.substring(dashindex + 1);
        author =a;
        display=d;
        preview=p;
        version=v;
    }

    public void run()
    {
        File jarFile;
        String jarString;
        WriteJarRunner wjr;
        
        MainWindow vindue = MainWindow.getDefaultInstance();
        try
        {
            zipFile = new File(fileName);
            fos = new  FileOutputStream(zipFile);
            zos = new ZipOutputStream(fos);
            bos = new BufferedOutputStream(zos);

            jarString="MT_tempjar";
	    Iterator iterator=Glossary.getDefaultInstance().getChildIterator();
	    install = (MozInstall)iterator.next();
        
            Log.write("Writing Natual");
            wjr = new WriteJarRunner(install,jarString,localeName,
		    author,display,preview,version);
            wjr.start(); wjr.join();
            jarFile = new File(jarString);
            copyFile(jarFile,"bin/chrome/" + localeName + ".jar");
	    bos.flush(); jarFile.delete();

            Log.write("Writing en-win");
	    install = (MozInstall)iterator.next();
            wjr = new WriteJarRunner(install
		    ,jarString,localeName, author,display,preview,version);
            wjr.start(); wjr.join();
            jarFile = new File(jarString);
            copyFile(jarFile,"bin/chrome/" + langcode + "-win" + ".jar");
	    bos.flush(); jarFile.delete();

            Log.write("Writing en-unix");
	    install = (MozInstall)iterator.next();
            wjr = new WriteJarRunner(install
		    ,jarString,localeName, author,display,preview,version);
            wjr.start(); wjr.join();
            jarFile = new File(jarString);
            copyFile(jarFile,"bin/chrome/" + langcode + "-unix" + ".jar");
	    bos.flush(); jarFile.delete();

            Log.write("Writing en-mac");
	    install = (MozInstall)iterator.next();
            wjr = new WriteJarRunner(install
		    ,jarString,localeName, author,display,preview,version);
            wjr.start(); wjr.join();
            jarFile = new File(jarString);
            copyFile(jarFile,"bin/chrome/" + langcode + "-mac" + ".jar");
	    bos.flush(); jarFile.delete();

            Log.write("Writing us");
	    install = (MozInstall)iterator.next();
            wjr = new WriteJarRunner(install
		    ,jarString,localeName, author,display,preview,version);
            wjr.start(); wjr.join();
            jarFile = new File(jarString);
            copyFile(jarFile,"bin/chrome/" + regioncode + ".jar");
	    bos.flush(); jarFile.delete();

            writeInstallScript();
            bos.close();

            // jarFile.delete();
        }
        catch (Exception e)
        {
            Log.write("Error writing jar file to xpi");
            Log.write("Exception: " +e);
        }
        MainWindow.getDefaultInstance().setStatus("Ready");
    }
    private void writeInstallScript()
    {
        Iterator componentIterator;
        MozComponent currentComponent;

        try
        {
            File fil = File.createTempFile("MT_",null);

            FileWriter fw= new FileWriter(fil);

            PrintWriter pw = new PrintWriter(fw);
            
            // the text in the file
	    pw.println("// this function verifies disk space in kilobytes");
	    pw.println("function verifyDiskSpace(dirPath, spaceRequired)");
	    pw.println("{");
	    pw.println("  var spaceAvailable;");
	    pw.println("");
	    pw.println("  // Get the available disk space on the given path");
	    pw.println("  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);");
	    pw.println("");
	    pw.println("  // Convert the available disk space into kilobytes");
	    pw.println("  spaceAvailable = parseInt(spaceAvailable / 1024);");
	    pw.println("");
	    pw.println("  // do the verification");
	    pw.println("  if(spaceAvailable < spaceRequired)");
	    pw.println("  {");
	    pw.println("    logComment(\"Insufficient disk space: \" + dirPath);");
	    pw.println("    logComment(\"  required : \" + spaceRequired + \" K\");");
	    pw.println("    logComment(\"  available: \" + spaceAvailable + \" K\");");
	    pw.println("    return(false);");
	    pw.println("  }");
	    pw.println("");
	    pw.println("  return(true);");
	    pw.println("}");
	    pw.println("");
	    pw.println("// OS type detection");
	    pw.println("// which platform?");
	    pw.println("function getPlatform()");
	    pw.println("{");
	    pw.println("  var platformStr;");
	    pw.println("  var platformNode;");
	    pw.println("");
	    pw.println("  if('platform' in Install)");
	    pw.println("  {");
	    pw.println("    platformStr = new String(Install.platform);");
	    pw.println("");
	    pw.println("    if (!platformStr.search(/^Macintosh/))");
	    pw.println("      platformNode = 'mac';");
	    pw.println("    else if (!platformStr.search(/^Win/))");
	    pw.println("      platformNode = 'win';");
	    pw.println("    else");
	    pw.println("      platformNode = 'unix';");
	    pw.println("  }");
	    pw.println("  else");
	    pw.println("  {");
	    pw.println("    var fOSMac  = getFolder(\"Mac System\");");
	    pw.println("    var fOSWin  = getFolder(\"Win System\");");
	    pw.println("");
	    pw.println("    logComment(\"fOSMac: \"  + fOSMac);");
	    pw.println("    logComment(\"fOSWin: \"  + fOSWin);");
	    pw.println("");
	    pw.println("    if(fOSMac != null)");
	    pw.println("      platformNode = 'mac';");
	    pw.println("    else if(fOSWin != null)");
	    pw.println("      platformNode = 'win';");
	    pw.println("    else");
	    pw.println("      platformNode = 'unix';");
	    pw.println("  }");
	    pw.println("");
	    pw.println("  return platformNode;");
	    pw.println("}");
	    pw.println("");
	    pw.println("");
	    pw.println("var srDest = 500;");
	    pw.println("var err;");
	    pw.println("var fProgram;");
	    pw.println("var platformNode;");
	    pw.println("");
	    pw.println("platformNode = getPlatform();");
	    pw.println("logComment(\"initInstall: platformNode=\" + platformNode);");
	    pw.println("// end - OS type detection");
	    pw.println("");
	    pw.println("// --- LOCALIZATION NOTE: translate only these ---");
            pw.println("var prettyName = \"" +display + "\";");
	    pw.println("var langcode = \"" + langcode + "\";");
	    pw.println("var regioncode = \"" + regioncode + "\";");
	    pw.println("var chromeNode = langcode + \"-\" + regioncode;");
	    pw.println("// --- END LOCALIZABLE RESOURCES ---");
	    pw.println("var regName    = \"locales/mozilla/\" + chromeNode;");
	    pw.println("var chromeName = chromeNode + \".jar\";");
	    pw.println("var regionFile = regioncode + \".jar\";");
	    pw.println("var platformName = langcode + \"-\" + platformNode + \".jar\";");
	    pw.println("var localeName = \"locale/\" + chromeNode + \"/\";");
	    pw.println("var regionName = \"locale/\" + regioncode + \"/\";");
	    pw.println("");
	    pw.println("err = initInstall(prettyName, regName, \"0.9.4\"); ");
	    pw.println("logComment(\"initInstall: \" + err);");
	    pw.println("");
	    pw.println("fProgram = getFolder(\"Program\");");
	    pw.println("logComment(\"fProgram: \" + fProgram);");
	    pw.println("");
	    pw.println("if (verifyDiskSpace(fProgram, srDest))");
	    pw.println("{");
	    pw.println("    var chromeType = LOCALE | DELAYED_CHROME;");
	    pw.println("    err = addDirectory(\"\",\"bin\",fProgram,\"\");");
	    pw.println("    logComment(\"addDirectory() returned: \" + err);");
	    pw.println("");
	    pw.println("    if (err != SUCCESS)");
	    pw.println("    {");
	    pw.println("        logComment(\"addDirectory() to \" + fProgram + \"failed!\");");
	    pw.println(" ");
	    pw.println("        // couldn't install globally, try installing to the profile");
	    pw.println("");
	    pw.println("// seems not to be working with DELAYED_CHROME !?");
	    pw.println("//        resetError();");
	    pw.println("//        chromeType |= PROFILE_CHROME;");
	    pw.println("//        fProgram = getFolder(\"Profile\");");
	    pw.println("//        logComment(\"try installing to the user profile:\" + fProgram);");
	    pw.println("//        err = addDirectory(\"\",\"bin/chrome\",fProgram,\"chrome\");");
	    pw.println("    }");
	    pw.println(" ");
	    pw.println("    setPackageFolder(fProgram);");
	    pw.println(" ");
	    pw.println("    // check return value");
	    pw.println("    if (err == SUCCESS)");
	    pw.println("    {");
	    pw.println("        // register chrome");
	    pw.println("        var cf = getFolder(fProgram, \"chrome/\"+chromeName);");
	    pw.println("        var pf = getFolder(fProgram, \"chrome/\"+platformName);");
	    pw.println("        var rf = getFolder(fProgram, \"chrome/\"+regionFile);");
	    pw.println("");
	    /* Cannot work:
	    // register chrome
	    Iterator iterator=Glossary.getDefaultInstance().getChildIterator();
	    while( iterator.hasNext() ) {
		install = (MozInstall)iterator.next();
		componentIterator = install.getChildIterator();
		while (componentIterator.hasNext())
		{
		    currentComponent = (MozComponent) componentIterator.next();
		    pw.println("    registerChrome(chromeType, cf, localeName + \"" + currentComponent.getName()+"/\");");
		    Log.write("registerChrome(chromeType, cf, localeName + \"" + currentComponent.getName()+"/\");");
		}
	    };
	    */
	    pw.println("        registerChrome(chromeType, cf, localeName + \"global/\");");
	    pw.println("        registerChrome(chromeType, cf, localeName + \"communicator/\");");
	    pw.println("");
	    pw.println("        registerChrome(chromeType, cf, localeName + \"messenger/\");");
	    pw.println("        registerChrome(chromeType, cf, localeName + \"editor/\");");
	    pw.println("        registerChrome(chromeType, cf, localeName + \"navigator/\");");
	    pw.println("        registerChrome(chromeType, cf, localeName + \"necko/\");");
	    pw.println("        registerChrome(chromeType, cf, localeName + \"cookie/\");");
	    pw.println("        registerChrome(chromeType, cf, localeName + \"wallet/\");");
	    pw.println("        registerChrome(chromeType, cf, localeName + \"content-packs/\");");
	    pw.println("        registerChrome(chromeType, cf, localeName + \"help/\");");
	    pw.println("        registerChrome(chromeType, cf, localeName + \"pipnss/\");");
	    pw.println("        registerChrome(chromeType, cf, localeName + \"pippki/\");");
	    pw.println("");
	    pw.println("        registerChrome(chromeType, pf, localeName + \"global-platform/\");");
	    pw.println("        registerChrome(chromeType, pf, localeName + \"communicator-platform/\");");
	    pw.println("        registerChrome(chromeType, pf, localeName + \"navigator-platform/\");");
	    pw.println("");
	    pw.println("        registerChrome(chromeType, rf, regionName + \"global-region/\");");
	    pw.println("        registerChrome(chromeType, rf, regionName + \"communicator-region/\");");
	    pw.println("        registerChrome(chromeType, rf, regionName + \"editor-region/\");");
	    pw.println("        registerChrome(chromeType, rf, regionName + \"messenger-region/\");");
	    pw.println("        registerChrome(chromeType, rf, regionName + \"navigator-region/\");");

	    pw.println("        err = performInstall(); ");
	    pw.println("        logComment(\"performInstall() returned: \" + err);");
	    pw.println("        if (err == SUCCESS)");
	    pw.println("        {");
	    pw.println("            alert(\"Installation finished. After a browser restart, you should be able to select to use this locale via Edit > Preferences (Appearance panel).\");");
	    pw.println("        }");
	    pw.println("        else");
	    pw.println("        {");
	    pw.println("            alert(\"Installation failed. Error code was \" + err);");
	    pw.println("        }");
	    pw.println("    }");
	    pw.println("    else");
	    pw.println("    {");
	    pw.println("        cancelInstall(err);");
	    pw.println("        logComment(\"cancelInstall due to error: \" + err);");
	    pw.println("        if (err == -202) {");
	    pw.println("           alert(\"Installation canceled with error \" + err +\". It seems you have no write permission to the Mozilla 'chrome' directory. Please install as root / system administrator.\");");
	    pw.println("        }");
	    pw.println("        else {");
	    pw.println("           alert(\"Installation canceled. Error code was \" + err);");
	    pw.println("        }");
	    pw.println("    }");
	    pw.println("}");
	    pw.println("else");
	    pw.println("    cancelInstall(INSUFFICIENT_DISK_SPACE);");
	    // end of piaip

            
            // end of text
            pw.close();
            copyFile(fil,"install.js");
            fil.delete();            
        }
        catch (Exception e)
        {
            Log.write("Error writing installScript file");
            Log.write("Exception :" + e); 
        }

    }

    private void copyFile(File tempFile,String eName) throws IOException
    {
        ZipEntry ze;
        FileInputStream fis;
        BufferedInputStream bis;
        boolean theEnd;
        int trans;
        ze = new ZipEntry(eName);
        zos.putNextEntry(ze);

        fis = new FileInputStream(tempFile);
        bis = new BufferedInputStream(fis);
        theEnd=false;

        while (!theEnd)
        {
            trans = bis.read();
            if (trans==-1)
            {
                theEnd = true;
            }
            else
            {
                bos.write(trans);
            }
        }
        bis.close();
        bos.flush(); 
    }



}
