/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 *  except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/

 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is MozillaTranslator (Mozilla Localization Tool)
 *
 * The Initial Developer of the Original Code is Henrik Lynggaard Hansen
 *
 * Portions created by Henrik Lynggard Hansen are
 * Copyright (C) Henrik Lynggaard Hansen.
 * All Rights Reserved.
 *
 * Contributor(s):
 * Henrik Lynggaard Hansen (Initial Code)
 *
 */
package org.mozilla.translator.kernel;


import org.mozilla.translator.datamodel.*;
import org.mozilla.translator.io.*;

/**
 *
 * @author  Henrik Lynggaard
 * @version 4.1
 */
public class BatchControl extends java.lang.Object 
{
	private static final String COM_UPDATE = "UPDATE";
	private static final String COM_SAVE = "SAVE";
	private static final String COM_WRITE_XPI ="WRITE_XPI";
	private static final String COM_FILE ="FILE";
	
	private static final int	UPDATE_PAREMS = 2;
			  
	public static void runBatch(String[] command)
	{
		if (command[0].equalsIgnoreCase(COM_UPDATE))
				  do_update(command);
		
		if (command[0].equalsIgnoreCase(COM_SAVE))
				  do_save(command);		
		
		if (command[0].equalsIgnoreCase(COM_FILE))
				  do_file(command);
		
	}
	
	private static void do_update(String[] com)
	{
		MozInstall install;
		String installName;
		
		if (com.length>=2)
		{
			installName = com[1];
		}			
	}
	
	private static void do_save(String[] com)
	{
        GlossaryAccess ga = new GlossaryAccess();
        ga.save();   
	}
	
	private static void do_file(String[] com)
	{
			  Log.write("File command");
	}	
}