/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 *  except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/

 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is MozillaTranslator (Mozilla Localization Tool)
 *
 * The Initial Developer of the Original Code is Henrik Lynggaard Hansen
 *
 * Portions created by Henrik Lynggard Hansen are
 * Copyright (C) Henrik Lynggaard Hansen.
 * All Rights Reserved.
 *
 * Contributor(s):
 * Henrik Lynggaard Hansen (Initial Code)
 *
 */
package org.mozilla.translator.gui.dialog;

import java.util.*;
import javax.swing.*;
import java.io.*;
import org.mozilla.translator.gui.*;
import org.mozilla.translator.datamodel.*;
import org.mozilla.translator.kernel.*;
/**
 *
 * @author  Henrik
 * @version
 */
public class ExportPartialGlossaryDialog extends javax.swing.JDialog
{

    /** Creates new form ExportPartialGlossaryDialoh */
    public ExportPartialGlossaryDialog() {
        super (MainWindow.getDefaultInstance(),"Export partial glossary",true);
        initComponents ();
        getRootPane().setDefaultButton(okButton);
        pack ();
        Utils.placeFrameAtCenter(this);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents () {//GEN-BEGIN:initComponents
        buttonPanel = new javax.swing.JPanel ();
        okButton = new javax.swing.JButton ();
        cancelButton = new javax.swing.JButton ();
        infoPanel = new javax.swing.JPanel ();
        installLabel = new javax.swing.JLabel ();
        installCombo = installCombo = new JComboBox(Glossary.getDefaultInstance().toArray());
        subcomponentLabel = new javax.swing.JLabel ();
        fileLabel = new javax.swing.JLabel ();
        fileField = new javax.swing.JTextField ();
        fileButton = new javax.swing.JButton ();
        listScroll = new javax.swing.JScrollPane ();
        subcomponentList = subcomponentList = new JList(getSubs());
        setDefaultCloseOperation (javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);


          okButton.setText ("OK");
          okButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  okButtonActionPerformed (evt);
              }
          }
          );
  
          buttonPanel.add (okButton);
  
          cancelButton.setText ("Cancel");
          cancelButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  cancelButtonActionPerformed (evt);
              }
          }
          );
  
          buttonPanel.add (cancelButton);
  

        getContentPane ().add (buttonPanel, java.awt.BorderLayout.SOUTH);

        infoPanel.setLayout (new java.awt.GridBagLayout ());
        java.awt.GridBagConstraints gridBagConstraints1;
        infoPanel.setBorder (new javax.swing.border.TitledBorder(
        new javax.swing.border.EtchedBorder(), "Information", 4, 2,
        new java.awt.Font ("Dialog", 0, 10)));

          installLabel.setText ("Install");
  
          gridBagConstraints1 = new java.awt.GridBagConstraints ();
          gridBagConstraints1.gridx = 0;
          gridBagConstraints1.gridy = 1;
          gridBagConstraints1.insets = new java.awt.Insets (3, 3, 0, 0);
          gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
          infoPanel.add (installLabel, gridBagConstraints1);
  
          installCombo.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  installComboActionPerformed (evt);
              }
          }
          );
  
          gridBagConstraints1 = new java.awt.GridBagConstraints ();
          gridBagConstraints1.gridx = 1;
          gridBagConstraints1.gridy = 1;
          gridBagConstraints1.gridwidth = 0;
          gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
          gridBagConstraints1.insets = new java.awt.Insets (3, 3, 0, 0);
          infoPanel.add (installCombo, gridBagConstraints1);
  
          subcomponentLabel.setText ("Subcomponents");
  
          gridBagConstraints1 = new java.awt.GridBagConstraints ();
          gridBagConstraints1.gridx = 0;
          gridBagConstraints1.gridy = 2;
          gridBagConstraints1.insets = new java.awt.Insets (3, 3, 0, 0);
          gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
          infoPanel.add (subcomponentLabel, gridBagConstraints1);
  
          fileLabel.setText ("File");
  
          gridBagConstraints1 = new java.awt.GridBagConstraints ();
          gridBagConstraints1.gridx = 0;
          gridBagConstraints1.gridy = 0;
          gridBagConstraints1.insets = new java.awt.Insets (3, 3, 0, 0);
          gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
          infoPanel.add (fileLabel, gridBagConstraints1);
  
          fileField.setColumns (20);
          fileField.setText ("I hate IE");
  
          gridBagConstraints1 = new java.awt.GridBagConstraints ();
          gridBagConstraints1.gridx = 1;
          gridBagConstraints1.gridy = 0;
          gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
          gridBagConstraints1.insets = new java.awt.Insets (3, 3, 0, 0);
          infoPanel.add (fileField, gridBagConstraints1);
  
          fileButton.setText ("Choose");
          fileButton.addActionListener (new java.awt.event.ActionListener () {
              public void actionPerformed (java.awt.event.ActionEvent evt) {
                  fileButtonActionPerformed (evt);
              }
          }
          );
  
          gridBagConstraints1 = new java.awt.GridBagConstraints ();
          gridBagConstraints1.gridx = 2;
          gridBagConstraints1.gridy = 0;
          gridBagConstraints1.gridwidth = 0;
          gridBagConstraints1.insets = new java.awt.Insets (3, 3, 0, 0);
          infoPanel.add (fileButton, gridBagConstraints1);
  
  
            subcomponentList.setPrototypeCellValue ("some very long subcomponent");
    
            listScroll.setViewportView (subcomponentList);
    
          gridBagConstraints1 = new java.awt.GridBagConstraints ();
          gridBagConstraints1.gridx = 1;
          gridBagConstraints1.gridy = 2;
          gridBagConstraints1.gridwidth = 0;
          gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
          gridBagConstraints1.insets = new java.awt.Insets (3, 3, 0, 0);
          infoPanel.add (listScroll, gridBagConstraints1);
  

        getContentPane ().add (infoPanel, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

  private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    okay=false;
    setVisible(false);
  }//GEN-LAST:event_cancelButtonActionPerformed

  private void okButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
    okay=true;
    setVisible(false);
  }//GEN-LAST:event_okButtonActionPerformed

  private void fileButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fileButtonActionPerformed
    File defaultFile = new File(fileField.getText());
    JFileChooser dirChooser = new JFileChooser();
    dirChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
    dirChooser.setDialogTitle("Select file to export to");
    dirChooser.setSelectedFile(defaultFile);
    int result = dirChooser.showDialog(this,"Choose");
    if (result==JFileChooser.APPROVE_OPTION)
    {
        File dir = dirChooser.getSelectedFile();
        fileField.setText(dir.toString());
    }
  }//GEN-LAST:event_fileButtonActionPerformed

  private void installComboActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_installComboActionPerformed
    subcomponentList.setListData(getSubs());
  }//GEN-LAST:event_installComboActionPerformed

/** Closes the dialog */
public Object[] getSubs()
{
    Iterator componentIterator;
    MozComponent currentComponent;
    List result = new ArrayList();
    MozInstall install = (MozInstall) installCombo.getSelectedItem();

    componentIterator = install.getChildIterator();

    while (componentIterator.hasNext())
    {
        currentComponent = (MozComponent) componentIterator.next();

        result.addAll(currentComponent.getAllChildren());
    }

    return result.toArray();
}


public boolean visDialog()
{
    MozInstall preSelect;
    fileField.setText(Settings.getString("saved.fileName.partial.export",""));
    preSelect = (MozInstall) Glossary.getDefaultInstance().getChildByName(Settings.getString("saved.install",""));
    if (preSelect!=null)
    {
        installCombo.setSelectedItem(preSelect);
        subcomponentList.setListData(getSubs());
    }
    setVisible(true);

    if (okay)
    {
        Settings.setString("saved.fileName.partial.export",fileField.getText());
        Settings.setString("saved.install",installCombo.getSelectedItem().toString());
    }
    return okay;
}

public String getFileName()
{
    return fileField.getText();
}

public MozInstall getInstall()
{
    return (MozInstall) installCombo.getSelectedItem();
}

public Object[] getSubcomponents()
{
    Object obj;
    Object[] result = subcomponentList.getSelectedValues();

    for (int i=0;i<result.length;i++)
    {
        obj = result[i];
    }
    return result;


}





// Variables declaration - do not modify//GEN-BEGIN:variables
private javax.swing.JPanel buttonPanel;
private javax.swing.JButton okButton;
private javax.swing.JButton cancelButton;
private javax.swing.JPanel infoPanel;
private javax.swing.JLabel installLabel;
private javax.swing.JComboBox installCombo;
private javax.swing.JLabel subcomponentLabel;
private javax.swing.JLabel fileLabel;
private javax.swing.JTextField fileField;
private javax.swing.JButton fileButton;
private javax.swing.JScrollPane listScroll;
private javax.swing.JList subcomponentList;
// End of variables declaration//GEN-END:variables
        private boolean okay;
    }