/*
 * AdvancedSearchDialog.java
 *
 * Created on 6. september 2000, 21:11
 */

package org.mozilla.translator.gui.dialog;

import javax.swing.*;
import org.mozilla.translator.kernel.*;
import org.mozilla.translator.datamodel.*;

/**
 *
 * @author  Henrik Lynggaard
 * @version 
 */
public class AdvancedSearchDialog extends javax.swing.JDialog {

    private boolean okay;
    private boolean all;
    
    /** Creates new form AdvancedSearchDialog */
    public AdvancedSearchDialog(java.awt.Frame parent,boolean modal) {
        super (parent, modal);
        initComponents ();
        pack ();
        Utils.placeFrameAtCenter(this);        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        fieldLabel = new javax.swing.JLabel();
        ruleLabel = new javax.swing.JLabel();
        textLabel = new javax.swing.JLabel();
        localeLabel = new javax.swing.JLabel();
        firstField = new javax.swing.JComboBox();
        firstRule = new javax.swing.JComboBox();
        firstText = new javax.swing.JTextField();
        firstLocale = new javax.swing.JTextField();
        firstEnable = new javax.swing.JCheckBox();
        secondEnable = new javax.swing.JCheckBox();
        secondField = new javax.swing.JComboBox();
        secondRule = new javax.swing.JComboBox();
        secondText = new javax.swing.JTextField();
        secondLocale = new javax.swing.JTextField();
        thirdEnable = new javax.swing.JCheckBox();
        thirdField = new javax.swing.JComboBox();
        thirdRule = new javax.swing.JComboBox();
        thirdText = new javax.swing.JTextField();
        thirdLocale = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        anyButton = new javax.swing.JButton();
        allButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        caseLabel = new javax.swing.JLabel();
        firstCase = new javax.swing.JCheckBox();
        secondCase = new javax.swing.JCheckBox();
        thirdCase = new javax.swing.JCheckBox();
        getContentPane().setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        }
        );
        
        fieldLabel.setText("Field");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(fieldLabel, gridBagConstraints1);
        
        
        ruleLabel.setText("Rule ");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(ruleLabel, gridBagConstraints1);
        
        
        textLabel.setText("text");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(textLabel, gridBagConstraints1);
        
        
        localeLabel.setText("locale");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 4;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(localeLabel, gridBagConstraints1);
        
        
        firstField.addItem("Key");
        firstField.addItem("Localization note");
        firstField.addItem("Original text");
        firstField.addItem("Translated text");
        firstField.addItem("QA comment");
        
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        getContentPane().add(firstField, gridBagConstraints1);
        
        
        firstRule.addItem("Is");
        firstRule.addItem("Is not");
        firstRule.addItem("Contains");
        firstRule.addItem("Doesn't contain");
        firstRule.addItem("Starts with");
        firstRule.addItem("Ends with");
        
        
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        getContentPane().add(firstRule, gridBagConstraints1);
        
        
        firstText.setColumns(15);
        firstText.setText("empty");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 1;
        getContentPane().add(firstText, gridBagConstraints1);
        
        
        firstLocale.setColumns(10);
        firstLocale.setText("empty");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 4;
        gridBagConstraints1.gridy = 1;
        getContentPane().add(firstLocale, gridBagConstraints1);
        
        
        firstEnable.setText("Enabled");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        getContentPane().add(firstEnable, gridBagConstraints1);
        
        
        secondEnable.setText("Enabled");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        getContentPane().add(secondEnable, gridBagConstraints1);
        
        
        secondField.addItem("Key");
        secondField.addItem("Localization note");
        secondField.addItem("Original text");
        secondField.addItem("Translated text");
        secondField.addItem("QA comment");
        
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        getContentPane().add(secondField, gridBagConstraints1);
        
        
        secondRule.addItem("Is");
        secondRule.addItem("Is not");
        secondRule.addItem("Contains");
        secondRule.addItem("Doesn't contain");
        secondRule.addItem("Starts with");
        secondRule.addItem("Ends with");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 2;
        getContentPane().add(secondRule, gridBagConstraints1);
        
        
        secondText.setColumns(15);
        secondText.setText("empty");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 2;
        getContentPane().add(secondText, gridBagConstraints1);
        
        
        secondLocale.setColumns(10);
        secondLocale.setText("empty");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 4;
        gridBagConstraints1.gridy = 2;
        getContentPane().add(secondLocale, gridBagConstraints1);
        
        
        thirdEnable.setText("Enabled");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        getContentPane().add(thirdEnable, gridBagConstraints1);
        
        
        thirdField.addItem("Key");
        thirdField.addItem("Localization note");
        thirdField.addItem("Original text");
        thirdField.addItem("Translated text");
        thirdField.addItem("QA comment");
        
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 3;
        getContentPane().add(thirdField, gridBagConstraints1);
        
        
        thirdRule.addItem("Is");
        thirdRule.addItem("Is not");
        thirdRule.addItem("Contains");
        thirdRule.addItem("Doesn't contain");
        thirdRule.addItem("Starts with");
        thirdRule.addItem("Ends with");
        
        
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 3;
        getContentPane().add(thirdRule, gridBagConstraints1);
        
        
        thirdText.setColumns(15);
        thirdText.setText("empty");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 3;
        getContentPane().add(thirdText, gridBagConstraints1);
        
        
        thirdLocale.setColumns(10);
        thirdLocale.setText("empty");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 4;
        gridBagConstraints1.gridy = 3;
        getContentPane().add(thirdLocale, gridBagConstraints1);
        
        
        
        anyButton.setText("Any of the above");
          anyButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  anyButtonPressed(evt);
              }
          }
          );
          jPanel1.add(anyButton);
          
          
        allButton.setText("All of the above");
          allButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  allButtonPressed(evt);
              }
          }
          );
          jPanel1.add(allButton);
          
          
        cancelButton.setText("Cancel");
          cancelButton.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  cancelButtonPressed(evt);
              }
          }
          );
          jPanel1.add(cancelButton);
          
          
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(jPanel1, gridBagConstraints1);
        
        
        caseLabel.setText("Casesentitive");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 5;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(caseLabel, gridBagConstraints1);
        
        
        firstCase.setLabel("yes");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 5;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 0;
        getContentPane().add(firstCase, gridBagConstraints1);
        
        
        secondCase.setLabel("yes");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 5;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 0;
        getContentPane().add(secondCase, gridBagConstraints1);
        
        
        thirdCase.setLabel("yes");
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 5;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.gridwidth = 0;
        getContentPane().add(thirdCase, gridBagConstraints1);
        
    }//GEN-END:initComponents

  private void cancelButtonPressed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonPressed
        all=false;
        okay=false;
        setVisible(false);
  }//GEN-LAST:event_cancelButtonPressed

  private void allButtonPressed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_allButtonPressed
    all=true;
    okay=true;
    setVisible(false);
    
  }//GEN-LAST:event_allButtonPressed

  private void anyButtonPressed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_anyButtonPressed
        all=false;
        okay=true;
        setVisible(false);
        
  }//GEN-LAST:event_anyButtonPressed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        okay=false;
        setVisible (false);
      
    }//GEN-LAST:event_closeDialog

    public boolean getFirstEnabled()
    {
        return firstEnable.isSelected();
    }

    public boolean getSecondEnabled()
    {
        return secondEnable.isSelected();
    }
    public boolean getThirdEnabled()
    {
        return thirdEnable.isSelected();
    }
    
    public String getFirstColumn()
    {
        return firstField.getSelectedItem().toString();
    }
    
    public String getSecondColumn()
    {
        return secondField.getSelectedItem().toString();
    }

    public String getThirdColumn()
    {
        return thirdField.getSelectedItem().toString();
    }
    
    public String getFirstRule()
    {
        return firstRule.getSelectedItem().toString();
    }
    
    public String getSecondRule()
    {
        return secondRule.getSelectedItem().toString();
    }

    public String getThirdRule()
    {
        return secondRule.getSelectedItem().toString();
    }
    
    public String getFirstSearchText()
    {
        return firstText.getText();
    }

    public String getSecondSearchText()
    {
        return secondText.getText();
    }

    public String getThirdSearchText()
    {
        return thirdText.getText();
    }
    
    public String getFirstLocaleName()
    {
        return firstLocale.getText();
    }

    public String getSecondLocaleName()
    {
        return secondLocale.getText();
    }

    public String getThirdLocaleName()
    {
        return thirdLocale.getText();
    }
    
    public boolean getFirstCase()
    {
        return firstCase.isSelected();
    }
    public boolean getSecondCase()
    {
        return secondCase.isSelected();
    }
    
    public boolean getThirdCase()
    {
        return thirdCase.isSelected();
    }    
    
    public boolean getAllChoice()
    {
        return all;
    }
    public boolean visDialog()
    {
      
        // set enebled flags
        firstEnable.setSelected(Settings.getBoolean("advanced.search.enable.1",false));
        secondEnable.setSelected(Settings.getBoolean("advanced.search.enable.2",false));
        thirdEnable.setSelected(Settings.getBoolean("advanced.search.enable.3",false));
        
        // set field combo
        firstField.setSelectedIndex(Settings.getInteger("advanced.search.field.1",0));
        secondField.setSelectedIndex(Settings.getInteger("advanced.search.field.2",0));
        thirdField.setSelectedIndex(Settings.getInteger("advanced.search.field.3",0));
        
        // set rule combo
        firstRule.setSelectedIndex(Settings.getInteger("advanced.search.rule.1",0));
        secondRule.setSelectedIndex(Settings.getInteger("advanced.search.rule.2",0));
        thirdRule.setSelectedIndex(Settings.getInteger("advanced.search.rule.3",0));
        
        // set the text field
        firstText.setText(Settings.getString("advanced.search.text.1",""));
        secondText.setText(Settings.getString("advanced.search.text.2",""));
        thirdText.setText(Settings.getString("advanced.search.text.3",""));
        
        // set the locale field
        firstLocale.setText(Settings.getString("advanced.search.locale.1",""));
        secondLocale.setText(Settings.getString("advanced.search.locale.2",""));
        thirdLocale.setText(Settings.getString("advanced.search.locale.3",""));
        
        // set case flags
        firstCase.setSelected(Settings.getBoolean("advanced.search.case.1",false));
        secondCase.setSelected(Settings.getBoolean("advanced.search.case.2",false));
        thirdCase.setSelected(Settings.getBoolean("advanced.search.case.3",false));
        
        
        okay=false;
        setVisible(true);
        
        if (okay)
        {    
              Settings.setBoolean("advanced.search.enable.1",firstEnable.isSelected());
              Settings.setBoolean("advanced.search.enable.2",secondEnable.isSelected());
              Settings.setBoolean("advanced.search.enable.3",thirdEnable.isSelected());
              
              Settings.setInteger("advanced.search.field.1",firstField.getSelectedIndex());
              Settings.setInteger("advanced.search.field.2",secondField.getSelectedIndex());
              Settings.setInteger("advanced.search.field.3",thirdField.getSelectedIndex());
              
              Settings.setInteger("advanced.search.rule.1",firstRule.getSelectedIndex());
              Settings.setInteger("advanced.search.rule.2",secondRule.getSelectedIndex());
              Settings.setInteger("advanced.search.rule.3",thirdRule.getSelectedIndex());
              
              Settings.setString("advanced.search.text.1",firstText.getText());
              Settings.setString("advanced.search.text.2",secondText.getText());
              Settings.setString("advanced.search.text.3",thirdText.getText());
              
              Settings.setString("advanced.search.locale.1",firstLocale.getText());
              Settings.setString("advanced.search.locale.2",secondLocale.getText());
              Settings.setString("advanced.search.locale.3",thirdLocale.getText());
              
              Settings.setBoolean("advanced.search.case.1",firstCase.isSelected());
              Settings.setBoolean("advanced.search.case.2",secondCase.isSelected());
              Settings.setBoolean("advanced.search.case.3",thirdCase.isSelected());
        }
        return okay;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel fieldLabel;
    private javax.swing.JLabel ruleLabel;
    private javax.swing.JLabel textLabel;
    private javax.swing.JLabel localeLabel;
    private javax.swing.JComboBox firstField;
    private javax.swing.JComboBox firstRule;
    private javax.swing.JTextField firstText;
    private javax.swing.JTextField firstLocale;
    private javax.swing.JCheckBox firstEnable;
    private javax.swing.JCheckBox secondEnable;
    private javax.swing.JComboBox secondField;
    private javax.swing.JComboBox secondRule;
    private javax.swing.JTextField secondText;
    private javax.swing.JTextField secondLocale;
    private javax.swing.JCheckBox thirdEnable;
    private javax.swing.JComboBox thirdField;
    private javax.swing.JComboBox thirdRule;
    private javax.swing.JTextField thirdText;
    private javax.swing.JTextField thirdLocale;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton anyButton;
    private javax.swing.JButton allButton;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel caseLabel;
    private javax.swing.JCheckBox firstCase;
    private javax.swing.JCheckBox secondCase;
    private javax.swing.JCheckBox thirdCase;
    // End of variables declaration//GEN-END:variables

}
